/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.CostAdjuster;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreatureOrPlaneswalkerPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

enum MobilizedDistrictAdjuster implements CostAdjuster
{
    instance;

    private static final FilterPermanent filter;
    static final DynamicValue cardsCount;
    private static final Hint hint;

    public static Hint getHint() {
        return hint;
    }

    public void reduceCost(Ability ability, Game game) {
        Player controller = game.getPlayer(ability.getControllerId());
        if (controller != null) {
            int count = cardsCount.calculate(game, ability, null);
            CardUtil.reduceCost((Ability)ability, (int)count);
        }
    }

    static {
        filter = new FilterCreatureOrPlaneswalkerPermanent();
        filter.add((Predicate)SuperType.LEGENDARY.getPredicate());
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        cardsCount = new PermanentsOnBattlefieldCount(filter);
        hint = new ValueHint("Legendary creatures and planeswalkers you control", cardsCount);
    }
}

