/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ModelOfUnityEffect
extends OneShotEffect {
    ModelOfUnityEffect() {
        super(Outcome.Benefit);
        this.staticText = "you and each opponent who voted for a choice you voted for may scry 2";
    }

    private ModelOfUnityEffect(ModelOfUnityEffect effect) {
        super((OneShotEffect)effect);
    }

    public ModelOfUnityEffect copy() {
        return new ModelOfUnityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.chooseUse(this.outcome, "Scry 2?", source, game)) {
            controller.scry(2, source, game);
        }
        Set playerIds = (Set)this.getValue("votedAgainst");
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player player;
            if (playerIds.contains(opponentId) || (player = game.getPlayer(opponentId)) == null || !player.chooseUse(this.outcome, "Scry 2?", source, game)) continue;
            player.scry(2, source, game);
        }
        return true;
    }
}

