/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.abilities.keyword.DefenderAbility;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MoltenSentryEffect
extends OneShotEffect {
    MoltenSentryEffect() {
        super(Outcome.Damage);
    }

    private MoltenSentryEffect(MoltenSentryEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        HasteAbility gainedAbility;
        int toughness;
        int power;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (controller == null || permanent == null) {
            return false;
        }
        if (controller.flipCoin(source, game, false)) {
            game.informPlayers("Heads: " + permanent.getLogName() + " enters the battlefield as a 5/2 creature with haste");
            power = 5;
            toughness = 2;
            gainedAbility = HasteAbility.getInstance();
        } else {
            game.informPlayers("Tails: " + permanent.getLogName() + " enters the battlefield as a 2/5 creature with defender");
            power = 2;
            toughness = 5;
            gainedAbility = DefenderAbility.getInstance();
        }
        game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(power, toughness, Duration.WhileOnBattlefield), source);
        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)gainedAbility, Duration.WhileOnBattlefield), source);
        return true;
    }

    public MoltenSentryEffect copy() {
        return new MoltenSentryEffect(this);
    }
}

