/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.Set;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MomirVigSimicVisionaryEffect
extends OneShotEffect {
    MomirVigSimicVisionaryEffect() {
        super(Outcome.DrawCard);
        this.staticText = "reveal the top card of your library. If it's a creature card, put that card into your hand";
    }

    private MomirVigSimicVisionaryEffect(MomirVigSimicVisionaryEffect effect) {
        super((OneShotEffect)effect);
    }

    public MomirVigSimicVisionaryEffect copy() {
        return new MomirVigSimicVisionaryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        cards.addAllCards((Collection)controller.getLibrary().getTopCards(game, 1));
        controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
        Set cardsList = cards.getCards(game);
        CardsImpl cardsToHand = new CardsImpl();
        for (Card card : cardsList) {
            if (!card.isCreature(game)) continue;
            cardsToHand.add(card);
            cards.remove(card);
        }
        controller.moveCards((Cards)cardsToHand, Zone.HAND, source, game);
        return true;
    }
}

