/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.cards.m.MonoxaMidwayManagerEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DieRolledEvent;
import mage.game.events.GameEvent;

class MonoxaMidwayManagerTriggeredAbility
extends TriggeredAbilityImpl {
    MonoxaMidwayManagerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainAbilitySourceEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn));
        this.addEffect((Effect)new MonoxaMidwayManagerEffect());
    }

    private MonoxaMidwayManagerTriggeredAbility(MonoxaMidwayManagerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MonoxaMidwayManagerTriggeredAbility copy() {
        return new MonoxaMidwayManagerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DIE_ROLLED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        int result = ((DieRolledEvent)event).getResult();
        if (!this.isControlledBy(event.getTargetId()) || result < 3) {
            return false;
        }
        this.getEffects().setValue("dieRoll", (Object)result);
        return true;
    }

    public String getRule() {
        return "Whenever you roll a 3 or higher, {this} gains first strike until end of turn. If the roll was 4 or higher, it gains menace until end of turn. If the roll was 5 or higher, it gains lifelink until end of turn.";
    }
}

