/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MonsoonEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    public MonsoonEffect() {
        super(Outcome.Damage);
        this.staticText = "tap all untapped Islands that player controls and {this} deals X damage to the player, where X is the number of Islands tapped this way";
    }

    private MonsoonEffect(MonsoonEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player != null) {
            int damage = 0;
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents(filter, player.getId(), game)) {
                permanent.tap(source, game);
                ++damage;
            }
            player.damage(damage, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }

    public MonsoonEffect copy() {
        return new MonsoonEffect(this);
    }

    static {
        filter.add((Predicate)SubType.ISLAND.getPredicate());
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

