/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class MoonringMirrorEffect
extends OneShotEffect {
    MoonringMirrorEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may exile all cards from your hand face down. If you do, put all other cards you own exiled with {this} into your hand";
    }

    private MoonringMirrorEffect(MoonringMirrorEffect effect) {
        super((OneShotEffect)effect);
    }

    public MoonringMirrorEffect copy() {
        return new MoonringMirrorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
        ExileZone exileZone = game.getExile().getExileZone(exileZoneId);
        CardsImpl cardsToHand = null;
        if (exileZone != null && !exileZone.isEmpty()) {
            cardsToHand = new CardsImpl((Collection)exileZone);
        }
        for (Card card : controller.getHand().getCards(game)) {
            card.setFaceDown(true, game);
        }
        controller.moveCardsToExile(controller.getHand().getCards(game), source, game, false, exileZoneId, sourceObject.getIdName());
        if (cardsToHand != null) {
            controller.moveCards(cardsToHand.getCards(game), Zone.HAND, source, game, false, true, false, null);
        }
        if ((exileZone = game.getExile().getExileZone(exileZoneId)) != null && !exileZone.isEmpty()) {
            for (Card card : game.getExile().getExileZone(exileZoneId).getCards(game)) {
                card.setFaceDown(true, game);
            }
        }
        return true;
    }
}

