/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.UntapAllEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.cards.m.MotivatedPonyWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.players.Player;

class MotivatedPonyEffect
extends OneShotEffect {
    MotivatedPonyEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "attacking creatures get +1/+1 until end of turn. If a Food entered the battlefield under your control this turn, untap those creatures and they get an additional +2/+2 until end of turn.";
    }

    private MotivatedPonyEffect(MotivatedPonyEffect ability) {
        super((OneShotEffect)ability);
    }

    public MotivatedPonyEffect copy() {
        return new MotivatedPonyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MotivatedPonyWatcher watcher = (MotivatedPonyWatcher)game.getState().getWatcher(MotivatedPonyWatcher.class);
        if (controller == null || watcher == null) {
            return false;
        }
        boolean additionalEffect = watcher.checkPlayer(controller.getId());
        int valueBoost = additionalEffect ? 3 : 1;
        game.addEffect((ContinuousEffect)new BoostAllEffect(valueBoost, valueBoost, Duration.EndOfTurn, (FilterCreaturePermanent)StaticFilters.FILTER_ATTACKING_CREATURES, false), source);
        if (additionalEffect) {
            new UntapAllEffect((FilterPermanent)StaticFilters.FILTER_ATTACKING_CREATURES).apply(game, source);
        }
        return true;
    }
}

