/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class MrFoxgloveEffect
extends OneShotEffect {
    MrFoxgloveEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw cards equal to the number of cards in defending player's hand minus the number of cards in your hand. If you didn't draw cards this way, you may put a creature card from your hand onto the battlefield.";
    }

    private MrFoxgloveEffect(MrFoxgloveEffect effect) {
        super((OneShotEffect)effect);
    }

    public MrFoxgloveEffect copy() {
        return new MrFoxgloveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        TargetCardInHand target;
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || player == null) {
            return false;
        }
        int cardsToDraw = player.getHand().size() - controller.getHand().size();
        int cardsDrawn = 0;
        if (cardsToDraw > 0) {
            cardsDrawn = controller.drawCards(cardsToDraw, source, game);
        }
        if ((cardsToDraw <= 0 || cardsDrawn == 0) && controller.chooseUse(Outcome.PutCardInPlay, "Put a creature card from your hand onto the battlefield?", source, game) && controller.choose(Outcome.PutCardInPlay, (Target)(target = new TargetCardInHand((FilterCard)StaticFilters.FILTER_CARD_CREATURE_A)), source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            return controller.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, false, null);
        }
        return true;
    }
}

