/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.cards.Card;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.watchers.Watcher;

class MuldrothaTheGravetideWatcher
extends Watcher {
    private final HashMap<MageObjectReference, Set<CardType>> sourcePlayedPermanentTypes = new HashMap();
    private Zone fromZone;

    public MuldrothaTheGravetideWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.PLAY_LAND) {
            this.fromZone = game.getState().getZone(event.getTargetId());
        }
        if (event.getType() == GameEvent.EventType.LAND_PLAYED && this.fromZone == Zone.GRAVEYARD) {
            this.addPermanentTypes(event, (Card)game.getPermanentOrLKIBattlefield(event.getTargetId()), game);
        }
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (spell = (Spell)game.getObject(event.getTargetId())).getFromZone() == Zone.GRAVEYARD) {
            this.addPermanentTypes(event, (Card)spell, game);
        }
    }

    private void addPermanentTypes(GameEvent event, Card mageObject, Game game) {
        if (mageObject != null && event.getApprovingObject() != null && MageIdentifier.MuldrothaTheGravetideWatcher.equals((Object)event.getApprovingObject().getApprovingAbility().getIdentifier())) {
            UUID playerId = null;
            if (mageObject instanceof Spell) {
                playerId = ((Spell)mageObject).getControllerId();
            } else if (mageObject instanceof Permanent) {
                playerId = ((Permanent)mageObject).getControllerId();
            }
            if (playerId != null) {
                Set<CardType> permanentTypes = this.sourcePlayedPermanentTypes.get(event.getApprovingObject().getApprovingMageObjectReference());
                if (permanentTypes == null) {
                    permanentTypes = EnumSet.noneOf(CardType.class);
                    this.sourcePlayedPermanentTypes.put(event.getApprovingObject().getApprovingMageObjectReference(), permanentTypes);
                }
                EnumSet<CardType> typesNotCast = EnumSet.noneOf(CardType.class);
                for (CardType cardType : mageObject.getCardType(game)) {
                    if (!cardType.isPermanentType() || permanentTypes.contains(cardType)) continue;
                    typesNotCast.add(cardType);
                }
                if (typesNotCast.size() <= 1) {
                    permanentTypes.addAll(typesNotCast);
                } else {
                    Player player = game.getPlayer(playerId);
                    if (player != null) {
                        ChoiceImpl typeChoice = new ChoiceImpl(true);
                        typeChoice.setMessage("Choose permanent type you consume for casting from graveyard.");
                        for (CardType cardType : typesNotCast) {
                            typeChoice.getChoices().add(cardType.toString());
                        }
                        if (player.choose(Outcome.Detriment, (Choice)typeChoice, game)) {
                            String typeName = typeChoice.getChoice();
                            CardType chosenType = null;
                            for (CardType cardType : CardType.values()) {
                                if (!cardType.toString().equals(typeName)) continue;
                                chosenType = cardType;
                                break;
                            }
                            if (chosenType != null) {
                                permanentTypes.add(chosenType);
                            }
                        }
                    }
                }
            }
        }
    }

    public void reset() {
        this.sourcePlayedPermanentTypes.clear();
        super.reset();
    }

    public boolean permanentTypePlayedFromGraveyard(MageObjectReference sourceMor, CardType cardType) {
        Set<CardType> permanentTypes = this.sourcePlayedPermanentTypes.get(sourceMor);
        if (permanentTypes != null) {
            return permanentTypes.contains(cardType);
        }
        return false;
    }
}

