/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MultiversalPassagePassageEffect
extends ContinuousEffectImpl {
    MultiversalPassagePassageEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Neutral);
        this.staticText = "This land is the chosen type.";
    }

    private MultiversalPassagePassageEffect(MultiversalPassagePassageEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public MultiversalPassagePassageEffect copy() {
        return new MultiversalPassagePassageEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        SubType choice = SubType.byDescription((String)((String)game.getState().getValue(source.getSourceId().toString() + "BasicLandType")));
        if (choice == null) {
            this.discard();
            return;
        }
        switch (choice) {
            case PLAINS: {
                this.dependencyTypes.add(DependencyType.BecomePlains);
                break;
            }
            case ISLAND: {
                this.dependencyTypes.add(DependencyType.BecomeIsland);
                break;
            }
            case SWAMP: {
                this.dependencyTypes.add(DependencyType.BecomeSwamp);
                break;
            }
            case MOUNTAIN: {
                this.dependencyTypes.add(DependencyType.BecomeMountain);
                break;
            }
            case FOREST: {
                this.dependencyTypes.add(DependencyType.BecomeForest);
            }
        }
    }

    public boolean apply(Game game, Ability source) {
        WhiteManaAbility ability;
        SubType choice = SubType.byDescription((String)((String)game.getState().getValue(source.getSourceId().toString() + "BasicLandType")));
        if (choice == null) {
            return false;
        }
        switch (choice) {
            case PLAINS: {
                ability = new WhiteManaAbility();
                break;
            }
            case ISLAND: {
                ability = new BlueManaAbility();
                break;
            }
            case SWAMP: {
                ability = new BlackManaAbility();
                break;
            }
            case MOUNTAIN: {
                ability = new RedManaAbility();
                break;
            }
            case FOREST: {
                ability = new GreenManaAbility();
                break;
            }
            default: {
                ability = null;
            }
        }
        Permanent land = game.getPermanent(source.getSourceId());
        if (land == null || land.hasSubtype(choice, game)) {
            return false;
        }
        land.addSubType(game, new SubType[]{choice});
        land.addAbility((Ability)ability, source.getSourceId(), game);
        return true;
    }
}

