/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class MurderousBetrayalCost
extends CostImpl {
    MurderousBetrayalCost() {
        this.text = "Pay half your life, rounded up";
    }

    private MurderousBetrayalCost(MurderousBetrayalCost cost) {
        super((CostImpl)cost);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player controller = game.getPlayer(controllerId);
        return controller != null && (controller.getLife() < 1 || controller.canPayLifeCost(ability));
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        int currentLife = controller.getLife();
        int lifeToPay = Math.max(0, (currentLife + currentLife % 2) / 2);
        this.paid = lifeToPay <= 0 ? true : CardUtil.tryPayLife((int)lifeToPay, (Player)controller, (Ability)source, (Game)game);
        return this.paid;
    }

    public MurderousBetrayalCost copy() {
        return new MurderousBetrayalCost(this);
    }
}

