/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MurderousSpoilsEffect
extends OneShotEffect {
    MurderousSpoilsEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target nonblack creature. It can't be regenerated. You gain control of all Equipment that were attached to it.";
    }

    private MurderousSpoilsEffect(MurderousSpoilsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        if (target != null) {
            ArrayList<Permanent> attachments = new ArrayList<Permanent>();
            for (UUID uuid : target.getAttachments()) {
                Permanent attached = game.getPermanent(uuid);
                if (!attached.hasSubtype(SubType.EQUIPMENT, game)) continue;
                attachments.add(attached);
            }
            for (Permanent p : attachments) {
                GainControlTargetEffect gainControl = new GainControlTargetEffect(Duration.Custom);
                gainControl.setTargetPointer((TargetPointer)new FixedTarget(p, game));
                game.addEffect((ContinuousEffect)gainControl, source);
            }
            target.destroy(source, game, true);
            return true;
        }
        return false;
    }

    public MurderousSpoilsEffect copy() {
        return new MurderousSpoilsEffect(this);
    }
}

