/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class MurktideRegentTriggeredAbility
extends TriggeredAbilityImpl {
    public MurktideRegentTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()));
        this.setTriggerPhrase("Whenever an instant or sorcery card leaves your graveyard, ");
    }

    private MurktideRegentTriggeredAbility(MurktideRegentTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MurktideRegentTriggeredAbility copy() {
        return new MurktideRegentTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() == Zone.GRAVEYARD) {
            Card card = game.getCard(zEvent.getTargetId());
            return card != null && card.isInstantOrSorcery(game) && card.getOwnerId().equals(this.getControllerId());
        }
        return false;
    }
}

