/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetOpponent;

class MurmursFromBeyondEffect
extends OneShotEffect {
    MurmursFromBeyondEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal the top three cards of your library. An opponent chooses one of them. Put that card into your graveyard and the rest into your hand";
    }

    private MurmursFromBeyondEffect(MurmursFromBeyondEffect effect) {
        super((OneShotEffect)effect);
    }

    public MurmursFromBeyondEffect copy() {
        return new MurmursFromBeyondEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null && controller != null) {
            CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 3));
            if (!cards.isEmpty()) {
                Card cardToGraveyard;
                controller.revealCards(this.staticText, (Cards)cards, game);
                if (cards.size() == 1) {
                    cardToGraveyard = cards.getRandom(game);
                } else {
                    TargetOpponent target;
                    Player opponent;
                    Set opponents = game.getOpponents(controller.getId());
                    if (opponents.size() == 1) {
                        opponent = game.getPlayer((UUID)opponents.iterator().next());
                    } else {
                        target = new TargetOpponent(true);
                        controller.chooseTarget(Outcome.Detriment, (Target)target, source, game);
                        opponent = game.getPlayer(target.getFirstTarget());
                    }
                    target = new TargetCard(1, Zone.LIBRARY, new FilterCard());
                    opponent.chooseTarget(this.outcome, (Cards)cards, (TargetCard)target, source, game);
                    cardToGraveyard = game.getCard(target.getFirstTarget());
                }
                if (cardToGraveyard != null) {
                    controller.moveCards(cardToGraveyard, Zone.GRAVEYARD, source, game);
                    cards.remove(cardToGraveyard);
                }
                controller.moveCards((Cards)cards, Zone.HAND, source, game);
            }
            return true;
        }
        return false;
    }
}

