/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;

class MyrServitorReturnEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("cards named Myr Servitor");

    public MyrServitorReturnEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "each player returns all cards named Myr Servitor from their graveyard to the battlefield";
    }

    private MyrServitorReturnEffect(MyrServitorReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public MyrServitorReturnEffect copy() {
        return new MyrServitorReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.moveCards(player.getGraveyard().getCards(filter, game), Zone.BATTLEFIELD, source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)new NamePredicate("Myr Servitor"));
    }
}

