/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MyrWelderEffect
extends OneShotEffect {
    MyrWelderEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target artifact card from a graveyard";
    }

    private MyrWelderEffect(MyrWelderEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getFirstTarget());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (card != null && permanent != null) {
            card.moveToExile(this.getId(), "Myr Welder (Imprint)", source, game);
            permanent.imprint(card.getId(), game);
            return true;
        }
        return false;
    }

    public MyrWelderEffect copy() {
        return new MyrWelderEffect(this);
    }
}

