/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.OozeToken;
import mage.game.permanent.token.Token;
import mage.game.stack.StackObject;

class MysticGenesisEffect
extends OneShotEffect {
    MysticGenesisEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell. Create an X/X green Ooze creature token, where X is that spell's mana value";
    }

    private MysticGenesisEffect(MysticGenesisEffect effect) {
        super((OneShotEffect)effect);
    }

    public MysticGenesisEffect copy() {
        return new MysticGenesisEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject stackObject = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (stackObject != null) {
            game.getStack().counter(source.getFirstTarget(), source, game);
            return new CreateTokenEffect((Token)new OozeToken(stackObject.getManaValue(), stackObject.getManaValue())).apply(game, source);
        }
        return false;
    }
}

