/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.condition.CompoundCondition;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.ManaWasSpentCondition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardInYourGraveyard;

class MythosOfBrokkosEffect
extends OneShotEffect {
    private static final Condition condition = new CompoundCondition(new Condition[]{ManaWasSpentCondition.BLUE, ManaWasSpentCondition.BLACK});
    private static final FilterCard filter = new FilterPermanentCard("permanent cards");

    MythosOfBrokkosEffect() {
        super(Outcome.Benefit);
        this.staticText = "If {U}{B} was spent to cast this spell, search your library for a card, put that card into your graveyard, then shuffle.<br>Return up to two permanent cards from your graveyard to your hand.";
    }

    private MythosOfBrokkosEffect(MythosOfBrokkosEffect effect) {
        super((OneShotEffect)effect);
    }

    public MythosOfBrokkosEffect copy() {
        return new MythosOfBrokkosEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardInLibrary targetCardInLibrary;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (condition.apply(game, source) && player.searchLibrary(targetCardInLibrary = new TargetCardInLibrary(), source, game)) {
            Card card = game.getCard(targetCardInLibrary.getFirstTarget());
            if (card != null) {
                player.moveCards(card, Zone.GRAVEYARD, source, game);
            }
            player.shuffleLibrary(source, game);
        }
        TargetCardInYourGraveyard targetCard = new TargetCardInYourGraveyard(0, 2, filter, true);
        player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)targetCard, source, game);
        CardsImpl cards = new CardsImpl((Collection)targetCard.getTargets());
        return player.moveCards((Cards)cards, Zone.HAND, source, game);
    }

    public Condition getCondition() {
        return condition;
    }
}

