/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.condition.CompoundCondition;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.ManaWasSpentCondition;
import mage.abilities.condition.common.SourceMatchesFilterCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.FightTargetSourceEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;

class MythosOfIllunaEffect
extends OneShotEffect {
    private static final Condition condition = new CompoundCondition(new Condition[]{ManaWasSpentCondition.RED, ManaWasSpentCondition.GREEN});
    private static final Condition condition2 = new SourceMatchesFilterCondition((FilterPermanent)new FilterCreaturePermanent("it's a creature"));

    MythosOfIllunaEffect() {
        super(Outcome.Benefit);
        this.staticText = "Create a token that's a copy of target permanent. If {R}{G} was spent to cast this spell, instead create a token that's a copy of that permanent, except the token has \"When this token enters, if it's a creature, it fights up to one target creature you don't control.\"";
    }

    private MythosOfIllunaEffect(MythosOfIllunaEffect effect) {
        super((OneShotEffect)effect);
    }

    public MythosOfIllunaEffect copy() {
        return new MythosOfIllunaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId());
        if (!condition.apply(game, source)) {
            return effect.apply(game, source);
        }
        TriggeredAbility ability = new EntersBattlefieldTriggeredAbility((Effect)new FightTargetSourceEffect().setText("it fights up to one target creature you don't control")).setTriggerPhrase("When this token enters, ").withInterveningIf(condition2);
        ability.addTarget((Target)new TargetPermanent(0, 1, (FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL));
        effect.addAdditionalAbilities(new Ability[]{ability});
        return effect.apply(game, source);
    }

    public Condition getCondition() {
        return condition;
    }
}

