/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class ZoologicalStudyEffect
extends OneShotEffect {
    ZoologicalStudyEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill five cards, then return a creature card milled this way to your hand";
    }

    private ZoologicalStudyEffect(ZoologicalStudyEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZoologicalStudyEffect copy() {
        return new ZoologicalStudyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.millCards(5, source, game).getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        switch (cards.size()) {
            case 0: {
                return true;
            }
            case 1: {
                card = cards.getRandom(game);
                break;
            }
            default: {
                TargetCard target = new TargetCard(Zone.ALL, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
                player.choose(Outcome.PutCardInPlay, (Cards)cards, target, source, game);
                card = cards.get(target.getFirstTarget(), game);
            }
        }
        player.moveCards(card, Zone.HAND, source, game);
        return true;
    }
}

