/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.CommanderCardType;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.AttackedThisTurnWatcher;

class CommanderAttackedThisTurnCondition
implements Condition {
    private Ability ability;

    CommanderAttackedThisTurnCondition(Ability source) {
        this.ability = source;
    }

    public boolean apply(Game game, Ability source) {
        if (this.ability == null) {
            this.ability = source;
        }
        if (!this.ability.isControlledBy(game.getActivePlayerId())) {
            return false;
        }
        Player controller = game.getPlayer(this.ability.getControllerId());
        if (controller == null) {
            return false;
        }
        Set commanderIds = game.getPlayerList().stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(player -> game.getCommandersIds(player, CommanderCardType.COMMANDER_OR_OATHBREAKER, true)).flatMap(Collection::stream).collect(Collectors.toSet());
        AttackedThisTurnWatcher watcher = (AttackedThisTurnWatcher)game.getState().getWatcher(AttackedThisTurnWatcher.class);
        return watcher != null && watcher.getAttackedThisTurnCreaturesPermanentLKI().stream().filter(Objects::nonNull).anyMatch(permanent -> commanderIds.contains(permanent.getId()));
    }

    public String toString() {
        return "During that turn you attacked with a Commander";
    }
}

