/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.MayhemAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class GreenGoblinEffect
extends ContinuousEffectImpl {
    GreenGoblinEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Each nonland card in your graveyard has mayhem. The mayhem cost is equal to the card's mana cost.";
    }

    private GreenGoblinEffect(GreenGoblinEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.getGraveyard().getCards(game).stream().filter(Objects::nonNull).filter(card -> !card.getManaCost().getText().isEmpty()).filter(card -> !card.isLand(game)).forEach(card -> {
            MayhemAbility ability = new MayhemAbility(card, card.getManaCost().getText());
            ability.setSourceId(card.getId());
            ability.setControllerId(card.getOwnerId());
            game.getState().addOtherAbility(card, (Ability)ability);
        });
        return true;
    }

    public GreenGoblinEffect copy() {
        return new GreenGoblinEffect(this);
    }
}

