/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Set;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.n.NarsetEnlightenedMasterCastFromExileEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NarsetEnlightenedMasterExileEffect
extends OneShotEffect {
    NarsetEnlightenedMasterExileEffect() {
        super(Outcome.Discard);
        this.staticText = "exile the top four cards of your library. Until end of turn, you may cast noncreature spells from among those cards without paying their mana costs";
    }

    private NarsetEnlightenedMasterExileEffect(NarsetEnlightenedMasterExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (player != null && sourceObject != null) {
            Set cards = player.getLibrary().getTopCards(game, 4);
            player.moveCards(cards, Zone.EXILED, source, game);
            for (Card card : cards) {
                if (game.getState().getZone(card.getId()) != Zone.EXILED || card.isCreature(game) || card.isLand(game)) continue;
                NarsetEnlightenedMasterCastFromExileEffect effect = new NarsetEnlightenedMasterCastFromExileEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }

    public NarsetEnlightenedMasterExileEffect copy() {
        return new NarsetEnlightenedMasterExileEffect(this);
    }
}

