/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.ConditionalMana;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.n.NarsetOfTheAncientWayManaCondition;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class NarsetOfTheAncientWayManaEffect
extends OneShotEffect {
    NarsetOfTheAncientWayManaEffect() {
        super(Outcome.Benefit);
        this.staticText = "You gain 2 life. Add {U}, {R}, or {W}. Spend this mana only to cast a noncreature spell.";
    }

    private NarsetOfTheAncientWayManaEffect(NarsetOfTheAncientWayManaEffect effect) {
        super((OneShotEffect)effect);
    }

    public NarsetOfTheAncientWayManaEffect copy() {
        return new NarsetOfTheAncientWayManaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.gainLife(2, game, source);
        ChoiceColor choice = new ChoiceColor();
        choice.getChoices().remove("Green");
        choice.getChoices().remove("Black");
        player.choose(Outcome.PutManaInPool, (Choice)choice, game);
        ConditionalMana mana = new ConditionalMana(choice.getMana(1));
        mana.addCondition((Condition)new NarsetOfTheAncientWayManaCondition());
        player.getManaPool().addMana((Mana)mana, game, source);
        return true;
    }
}

