/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.n.NarsetTranscendentGainReboundEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NarsetTranscendentTriggeredAbility
extends DelayedTriggeredAbility {
    public NarsetTranscendentTriggeredAbility() {
        super((Effect)new NarsetTranscendentGainReboundEffect(), Duration.EndOfTurn, true);
        this.setTriggerPhrase("When you next cast an instant or sorcery spell from your hand this turn, ");
    }

    private NarsetTranscendentTriggeredAbility(NarsetTranscendentTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public NarsetTranscendentTriggeredAbility copy() {
        return new NarsetTranscendentTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        if (event.getPlayerId().equals(this.getControllerId()) && (spell = game.getStack().getSpell(event.getTargetId())) != null && spell.getFromZone() == Zone.HAND && spell.getCard() != null && spell.getCard().isInstantOrSorcery(game)) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(spell.getId()));
            }
            return true;
        }
        return false;
    }
}

