/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class NascentMetamorphEffect
extends OneShotEffect {
    NascentMetamorphEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent reveals cards from the top of their library until they reveal a creature card. {this} becomes a copy of that card until end of turn. Then that player puts all cards revealed this way on the bottom of their library in a random order.";
    }

    private NascentMetamorphEffect(NascentMetamorphEffect effect) {
        super((OneShotEffect)effect);
    }

    public NascentMetamorphEffect copy() {
        return new NascentMetamorphEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        CardsImpl toReveal = new CardsImpl();
        Card toCopy = null;
        for (Card card : player.getLibrary().getCards(game)) {
            toReveal.add(card);
            if (card == null || !card.isCreature(game)) continue;
            toCopy = card;
            break;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (toCopy != null && permanent != null) {
            game.copyPermanent(Duration.EndOfTurn, (Permanent)new PermanentCard(toCopy, source.getControllerId(), game), permanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
        }
        player.revealCards(source, (Cards)toReveal, game);
        player.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, false);
        return true;
    }
}

