/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.cards.n.NashiMoonSagesScionPlayEffect;
import mage.cards.n.NashiMoonSagesScionWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class NashiMoonSagesScionEffect
extends OneShotEffect {
    NashiMoonSagesScionEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of each player's library. Until end of turn, you may play one of those cards. If you cast a spell this way, pay life equal to its mana value rather than paying its mana cost";
    }

    private NashiMoonSagesScionEffect(NashiMoonSagesScionEffect effect) {
        super((OneShotEffect)effect);
    }

    public NashiMoonSagesScionEffect copy() {
        return new NashiMoonSagesScionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            cards.add(player.getLibrary().getFromTop(game));
        }
        Set cardSet = cards.getCards(game);
        controller.moveCardsToExile(cardSet, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        NashiMoonSagesScionWatcher.addCards(source, cardSet, game);
        for (Card card : cardSet) {
            game.addEffect((ContinuousEffect)new NashiMoonSagesScionPlayEffect(game, card), source);
        }
        return true;
    }
}

