/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class NashiSearcherInTheDarkEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("legendary and/or enchantment cards");

    NashiSearcherInTheDarkEffect() {
        super(Outcome.Benefit);
        this.staticText = "you mill that many cards. You may put any number of legendary and/or enchantment cards from among them into your hand. If you put no cards into your hand this way, put a +1/+1 counter on {this}";
    }

    private NashiSearcherInTheDarkEffect(NashiSearcherInTheDarkEffect effect) {
        super((OneShotEffect)effect);
    }

    public NashiSearcherInTheDarkEffect copy() {
        return new NashiSearcherInTheDarkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int amount = (Integer)this.getValue("damage");
        if (player == null || amount < 1) {
            return false;
        }
        Cards cards = player.millCards(amount, source, game);
        TargetCard target = new TargetCard(0, Integer.MAX_VALUE, Zone.ALL, filter);
        target.withNotTarget(true);
        player.choose(Outcome.ReturnToHand, cards, target, source, game);
        CardsImpl toHand = new CardsImpl((Collection)target.getTargets());
        player.moveCards((Cards)toHand, Zone.HAND, source, game);
        toHand.retainZone(Zone.HAND, game);
        if (toHand.isEmpty()) {
            Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).ifPresent(permanent -> permanent.addCounters(CounterType.P1P1.createInstance(), source, game));
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)SuperType.LEGENDARY.getPredicate(), (Predicate)CardType.ENCHANTMENT.getPredicate()));
    }
}

