/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class NaturalSelectionEffect
extends OneShotEffect {
    NaturalSelectionEffect() {
        super(Outcome.DrawCard);
        this.staticText = "look at the top three cards of target player's library, then put them back in any order. You may have that player shuffle";
    }

    private NaturalSelectionEffect(NaturalSelectionEffect effect) {
        super((OneShotEffect)effect);
    }

    public NaturalSelectionEffect copy() {
        return new NaturalSelectionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (targetPlayer == null || controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(targetPlayer.getLibrary().getTopCards(game, 3));
        controller.lookAtCards(source, null, (Cards)cards, game);
        controller.putCardsOnTopOfLibrary((Cards)cards, game, source, true);
        if (controller.chooseUse(Outcome.Neutral, "You may have that player shuffle", source, game)) {
            targetPlayer.shuffleLibrary(source, game);
        }
        return true;
    }
}

