/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.LinkedHashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.BandingAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class NaturesBlessingEffect
extends OneShotEffect {
    private static final Set<String> choices = new LinkedHashSet<String>();
    private Ability gainedAbility;

    public NaturesBlessingEffect() {
        super(Outcome.AddAbility);
        this.staticText = "Put a +1/+1 counter on target creature or that creature gains banding, first strike, or trample";
    }

    private NaturesBlessingEffect(NaturesBlessingEffect effect) {
        super((OneShotEffect)effect);
    }

    public NaturesBlessingEffect copy() {
        return new NaturesBlessingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && targetPermanent != null) {
            ChoiceImpl choice = new ChoiceImpl(true);
            choice.setMessage("Choose one");
            choice.setChoices(choices);
            if (controller.choose(this.outcome, (Choice)choice, game)) {
                switch (choice.getChoice()) {
                    case "Banding": {
                        this.gainedAbility = BandingAbility.getInstance();
                        break;
                    }
                    case "First strike": {
                        this.gainedAbility = FirstStrikeAbility.getInstance();
                        break;
                    }
                    case "Trample": {
                        this.gainedAbility = TrampleAbility.getInstance();
                    }
                }
            }
            if (this.gainedAbility != null) {
                game.addEffect((ContinuousEffect)new GainAbilityTargetEffect(this.gainedAbility, Duration.Custom), source);
            } else {
                targetPermanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
                game.informPlayers(controller.getLogName() + " puts a +1/+1 counter on " + targetPermanent.getLogName());
            }
            return true;
        }
        return false;
    }

    static {
        choices.add("+1/+1 counter");
        choices.add("Banding");
        choices.add("First strike");
        choices.add("Trample");
    }
}

