/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.LimitedTimesPerTurnActivatedAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.AttachedToMatchesFilterCondition;
import mage.abilities.condition.common.MyTurnCondition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapAttachedCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.UntapAttachedEffect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.common.MyTurnHint;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetControlledCreaturePermanent;

public final class NaturesChosen
extends CardImpl {
    private static final FilterPermanent filterPermanent = new FilterPermanent("artifact, creature or land");
    private static final FilterCreaturePermanent filterWhiteUntappedCreature;

    public NaturesChosen(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{G}");
        this.subtype.add((Object)SubType.AURA);
        TargetControlledCreaturePermanent auraTarget = new TargetControlledCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        this.addAbility(new LimitedTimesPerTurnActivatedAbility(Zone.BATTLEFIELD, (Effect)new UntapAttachedEffect(), (Cost)new GenericManaCost(0), 1, (Condition)MyTurnCondition.instance).addHint((Hint)MyTurnHint.instance));
        UntapTargetEffect effect = new UntapTargetEffect();
        effect.setText("Untap target artifact, creature, or land");
        LimitedTimesPerTurnActivatedAbility ability2 = new LimitedTimesPerTurnActivatedAbility(Zone.BATTLEFIELD, (Effect)effect, (Cost)new TapAttachedCost(), 1, (Condition)new AttachedToMatchesFilterCondition((FilterPermanent)filterWhiteUntappedCreature));
        ability2.addTarget((Target)new TargetPermanent(filterPermanent));
        this.addAbility((Ability)ability2);
    }

    private NaturesChosen(NaturesChosen card) {
        super((CardImpl)card);
    }

    public NaturesChosen copy() {
        return new NaturesChosen(this);
    }

    static {
        filterPermanent.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.LAND.getPredicate()}));
        filterWhiteUntappedCreature = new FilterCreaturePermanent("enchanted creature is white and untapped");
        filterWhiteUntappedCreature.add((Predicate)new ColorPredicate(ObjectColor.WHITE));
        filterWhiteUntappedCreature.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

