/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.AnyColorManaAbility;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class NearbyPlanetEffect
extends ContinuousEffectImpl {
    private static final Ability[] basicManaAbilities = new Ability[]{new WhiteManaAbility(), new BlueManaAbility(), new BlackManaAbility(), new RedManaAbility(), new GreenManaAbility()};

    NearbyPlanetEffect() {
        super(Duration.Custom, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.dependendToTypes.add(DependencyType.BecomeMountain);
        this.dependendToTypes.add(DependencyType.BecomeForest);
        this.dependendToTypes.add(DependencyType.BecomeSwamp);
        this.dependendToTypes.add(DependencyType.BecomeIsland);
        this.dependendToTypes.add(DependencyType.BecomePlains);
        this.staticText = "Rangeling <i>(This card is every land type, including Plains, Island, Swamp, Mountain, Forest, Desert, Gate, Lair, Locus, and all those Urza's ones.)</i>";
    }

    private NearbyPlanetEffect(NearbyPlanetEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public NearbyPlanetEffect copy() {
        return new NearbyPlanetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = game.getObject(source);
        if (sourceObject == null) {
            return false;
        }
        sourceObject.addSubType(game, new SubType[]{SubType.PLAINS, SubType.ISLAND, SubType.SWAMP, SubType.MOUNTAIN, SubType.FOREST});
        sourceObject.setIsAllNonbasicLandTypes(game, true);
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return true;
        }
        for (Ability basicManaAbility : basicManaAbilities) {
            if (!permanent.getAbilities(game).containsRule(basicManaAbility)) continue;
            permanent.removeAbility(basicManaAbility, source.getSourceId(), game);
        }
        AnyColorManaAbility ability = new AnyColorManaAbility();
        if (!permanent.getAbilities(game).containsRule((Ability)ability)) {
            permanent.addAbility((Ability)ability, source.getSourceId(), game);
        }
        return true;
    }
}

