/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class NecrodominanceEffect
extends OneShotEffect {
    NecrodominanceEffect() {
        super(Outcome.LoseLife);
        this.staticText = "you may pay any amount of life. If you do, draw that many cards";
    }

    private NecrodominanceEffect(NecrodominanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public NecrodominanceEffect copy() {
        return new NecrodominanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int payAmount = controller.getAmount(0, controller.getLife(), "Pay any amount of life", source, game);
        PayLifeCost cost = new PayLifeCost(payAmount);
        if (!cost.pay(source, game, source, source.getControllerId(), true)) {
            return false;
        }
        controller.drawCards(payAmount, source, game);
        return true;
    }
}

