/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderYourControlTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NecroskitterTriggeredAbility
extends TriggeredAbilityImpl {
    public NecroskitterTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ReturnToBattlefieldUnderYourControlTargetEffect(), true);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private NecroskitterTriggeredAbility(NecroskitterTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public NecroskitterTriggeredAbility copy() {
        return new NecroskitterTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent() && (permanent = zEvent.getTarget()) != null && permanent.getCounters(game).containsKey(CounterType.M1M1) && game.getOpponents(this.controllerId).contains(permanent.getControllerId())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game.getState().getZoneChangeCounter(event.getTargetId())));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature an opponent controls with a -1/-1 counter on it dies, you may return that card to the battlefield under your control.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

