/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Objects;
import java.util.stream.Stream;
import mage.MageItem;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.keyword.ScryEffect;
import mage.constants.Zone;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeGroupEvent;

class NefariousImpTriggeredAbility
extends TriggeredAbilityImpl {
    NefariousImpTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ScryEffect(1));
        this.setTriggerPhrase("Whenever one or more permanents you control leave the battlefield, ");
    }

    private NefariousImpTriggeredAbility(NefariousImpTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public NefariousImpTriggeredAbility copy() {
        return new NefariousImpTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_GROUP;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeGroupEvent zEvent = (ZoneChangeGroupEvent)event;
        if (zEvent.getFromZone() != Zone.BATTLEFIELD) return false;
        if (!Stream.concat(zEvent.getTokens().stream(), zEvent.getCards().stream().map(MageItem::getId).map(arg_0 -> ((Game)game).getPermanentOrLKIBattlefield(arg_0)).filter(Objects::nonNull)).map(Controllable::getControllerId).anyMatch(arg_0 -> ((NefariousImpTriggeredAbility)this).isControlledBy(arg_0))) return false;
        return true;
    }
}

