/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Optional;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.TransformSourceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class NeglectedHeirloomTriggeredAbility
extends TriggeredAbilityImpl {
    public NeglectedHeirloomTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TransformSourceEffect(), false);
        this.setTriggerPhrase("When equipped creature transforms, ");
    }

    private NeglectedHeirloomTriggeredAbility(NeglectedHeirloomTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TRANSFORMED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return Optional.ofNullable(this.getSourcePermanentIfItStillExists(game)).map(Permanent::getAttachedTo).filter(event.getTargetId()::equals).isPresent();
    }

    public NeglectedHeirloomTriggeredAbility copy() {
        return new NeglectedHeirloomTriggeredAbility(this);
    }
}

