/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.token.SaprolingToken;
import mage.game.permanent.token.Token;

class NemataPrimevalWardenEffect
extends ReplacementEffectImpl {
    NemataPrimevalWardenEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "If a creature an opponent controls would die, exile it instead. When you do, create a 1/1 green Saproling creature token.";
    }

    private NemataPrimevalWardenEffect(NemataPrimevalWardenEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public NemataPrimevalWardenEffect copy() {
        return new NemataPrimevalWardenEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ((ZoneChangeEvent)event).setToZone(Zone.EXILED);
        game.fireReflexiveTriggeredAbility(new ReflexiveTriggeredAbility((Effect)new CreateTokenEffect((Token)new SaprolingToken()), false, "If a creature an opponent controls would die, exile it instead. When you do, create a 1/1 green Saproling creature token"), source);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.isDiesEvent() && zEvent.getTarget() != null && zEvent.getTarget().isCreature(game) && game.getOpponents(zEvent.getTarget().getControllerId()).contains(source.getControllerId());
    }
}

