/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NemesisTrapEffect
extends OneShotEffect {
    NemesisTrapEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target attacking creature. Create a token that's a copy of that creature. Exile it at the beginning of the next end step";
    }

    private NemesisTrapEffect(NemesisTrapEffect effect) {
        super((OneShotEffect)effect);
    }

    public NemesisTrapEffect copy() {
        return new NemesisTrapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetedCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && targetedCreature != null) {
            controller.moveCards((Card)targetedCreature, Zone.EXILED, source, game);
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetedCreature, game));
            effect.apply(game, source);
            for (Permanent addedToken : effect.getAddedPermanents()) {
                ExileTargetEffect exileEffect = new ExileTargetEffect("Exile " + addedToken.getName() + " at the beginning of the next end step");
                exileEffect.setTargetPointer((TargetPointer)new FixedTarget(addedToken, game));
                AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)exileEffect);
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            }
            return true;
        }
        return false;
    }
}

