/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class NerivHeartOfTheStormEffect
extends ReplacementEffectImpl {
    NerivHeartOfTheStormEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "if a creature you control that entered this turn would deal damage, it deals twice that much damage instead";
    }

    private NerivHeartOfTheStormEffect(NerivHeartOfTheStormEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public NerivHeartOfTheStormEffect copy() {
        return new NerivHeartOfTheStormEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT || event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return Optional.ofNullable(game.getPermanentOrLKIBattlefield(event.getSourceId())).map(permanent -> permanent.isCreature(game) && permanent.getTurnsOnBattlefield() == 0 && permanent.isControlledBy(source.getControllerId())).orElse(false);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

