/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CommanderCardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class NetherbornAltarEffect
extends OneShotEffect {
    NetherbornAltarEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put your commander into your hand from the command zone. Then you lose 3 life for each soul counter on {this}.";
    }

    private NetherbornAltarEffect(NetherbornAltarEffect effect) {
        super((OneShotEffect)effect);
    }

    public NetherbornAltarEffect copy() {
        return new NetherbornAltarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList commandersInCommandZone = new ArrayList(game.getCommanderCardsFromCommandZone(controller, CommanderCardType.COMMANDER_OR_OATHBREAKER));
        if (commandersInCommandZone.size() == 1) {
            controller.moveCards((Card)commandersInCommandZone.get(0), Zone.HAND, source, game);
        } else if (commandersInCommandZone.size() == 2) {
            Card firstCommander = (Card)commandersInCommandZone.get(0);
            Card secondCommander = (Card)commandersInCommandZone.get(1);
            if (controller.chooseUse(Outcome.ReturnToHand, "Return which commander to hand?", null, firstCommander.getName(), secondCommander.getName(), source, game)) {
                controller.moveCards(firstCommander, Zone.HAND, source, game);
            } else {
                controller.moveCards(secondCommander, Zone.HAND, source, game);
            }
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (permanent != null) {
            int counterCount = permanent.getCounters(game).getCount(CounterType.SOUL);
            controller.loseLife(3 * counterCount, game, source, false);
        }
        return true;
    }
}

