/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.CyclingDiscardCost;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.abilities.keyword.CyclingAbility;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class NewPerspectivesCostModificationEffect
extends CostModificationEffectImpl {
    NewPerspectivesCostModificationEffect() {
        super(Duration.Custom, Outcome.Benefit, CostModificationType.SET_COST);
        this.staticText = "As long as you have seven or more cards in hand, you may pay {0} rather than pay cycling costs";
    }

    private NewPerspectivesCostModificationEffect(NewPerspectivesCostModificationEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Player controller = game.getPlayer(abilityToModify.getControllerId());
        return controller != null && controller.getId().equals(source.getControllerId()) && abilityToModify instanceof CyclingAbility && controller.getHand().size() >= 7;
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Player controller = game.getPlayer(abilityToModify.getControllerId());
        if (controller != null) {
            if (game.inCheckPlayableState() || controller.chooseUse(Outcome.PlayForFree, "Pay {0} to cycle?", source, game)) {
                abilityToModify.clearCosts();
                abilityToModify.clearManaCostsToPay();
                abilityToModify.addCost((Cost)new CyclingDiscardCost());
            }
            return true;
        }
        return false;
    }

    public NewPerspectivesCostModificationEffect copy() {
        return new NewPerspectivesCostModificationEffect(this);
    }
}

