/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToBattlefieldAttachedEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CommanderCardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class NextOfKinDiesEffect
extends OneShotEffect {
    NextOfKinDiesEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "you may put a creature card you own with lesser mana value from your hand or from the command zone onto the battlefield. If you do, return {this} to the battlefield attached to that creature at the beginning of the next end step.";
    }

    private NextOfKinDiesEffect(NextOfKinDiesEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card nextOfKinCard = source.getSourceCardIfItStillExists(game);
        Object object = this.getValue("attachedTo");
        if (controller == null || nextOfKinCard == null || !(object instanceof Permanent)) {
            return false;
        }
        int manaValue = ((Permanent)object).getManaValue();
        FilterCreatureCard filter = new FilterCreatureCard("a creature card you own with lesser mana value");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, manaValue));
        CardsImpl cards = new CardsImpl();
        cards.addAllCards((Collection)controller.getHand().getCards((FilterCard)filter, source.getControllerId(), source, game));
        for (Card possibleCard : game.getCommanderCardsFromCommandZone(controller, CommanderCardType.ANY)) {
            if (!filter.match(possibleCard, source.getControllerId(), source, game)) continue;
            cards.add(possibleCard);
        }
        if (cards.isEmpty()) {
            return true;
        }
        TargetCard target = new TargetCard(0, 1, Zone.ALL, (FilterCard)filter);
        target.withNotTarget(true);
        controller.choose(this.outcome, (Cards)cards, target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
            if (permanent != null) {
                ReturnToBattlefieldAttachedEffect returnToBattlefieldAttachedEffect = new ReturnToBattlefieldAttachedEffect();
                returnToBattlefieldAttachedEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)returnToBattlefieldAttachedEffect), source);
            }
        }
        return true;
    }

    public NextOfKinDiesEffect copy() {
        return new NextOfKinDiesEffect(this);
    }
}

