/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class NexusOfBecomingEffect
extends OneShotEffect {
    NexusOfBecomingEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then you may exile an artifact or creature card from your hand. If you do, create a token that's a copy of the exiled card, except it's a 3/3 Golem artifact creature in addition to its other types.";
    }

    private NexusOfBecomingEffect(NexusOfBecomingEffect effect) {
        super((OneShotEffect)effect);
    }

    public NexusOfBecomingEffect copy() {
        return new NexusOfBecomingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, StaticFilters.FILTER_CARD_ARTIFACT_OR_CREATURE);
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        return new CreateTokenCopyTargetEffect(null, CardType.CREATURE, false, 1, false, false, null, 3, 3, false).setBecomesArtifact(true).withAdditionalSubType(SubType.GOLEM).setSavedPermanent((Permanent)new PermanentCard(card, source.getControllerId(), game)).apply(game, source);
    }
}

