/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.n.NeyaliSunsVanguardWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class NeyaliSunsVanguardEffect
extends OneShotEffect {
    NeyaliSunsVanguardEffect() {
        super(Outcome.Benefit);
        this.setText("exile the top card of your library. During any turn you attacked with a token, you may play that card.");
    }

    private NeyaliSunsVanguardEffect(NeyaliSunsVanguardEffect effect) {
        super((OneShotEffect)effect);
    }

    public NeyaliSunsVanguardEffect copy() {
        return new NeyaliSunsVanguardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.moveCardsToExile(card, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.Custom, (boolean)false, (UUID)source.getControllerId(), NeyaliSunsVanguardWatcher::checkPlayer);
        return true;
    }
}

