/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.game.Graveyard;
import mage.players.Player;
import mage.target.common.TargetCardInGraveyard;

class NeyamShaiMuradEffect
extends OneShotEffect {
    NeyamShaiMuradEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may have that player return target permanent card from their graveyard to their hand. If you do, that player chooses a permanent card in your graveyard, then you put it onto the battlefield under your control";
    }

    private NeyamShaiMuradEffect(NeyamShaiMuradEffect effect) {
        super((OneShotEffect)effect);
    }

    public NeyamShaiMuradEffect copy() {
        return new NeyamShaiMuradEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Object playerId = this.getValue("damagedPlayer");
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || !(playerId instanceof UUID)) {
            return false;
        }
        Player player = game.getPlayer((UUID)playerId);
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        cards.retainZone(Zone.GRAVEYARD, game);
        if (player == null || cards.isEmpty() || !player.moveCards((Cards)cards, Zone.HAND, source, game)) {
            return false;
        }
        Graveyard controllerGraveyard = controller.getGraveyard();
        FilterPermanentCard filter = new FilterPermanentCard("a permanent card in your graveyard");
        filter.add((Predicate)new OwnerIdPredicate(source.getControllerId()));
        TargetCardInGraveyard target = new TargetCardInGraveyard(1, 1, (FilterCard)filter, true);
        if (!target.choose(Outcome.PutCreatureInPlay, player.getId(), source, game)) {
            return false;
        }
        return controllerGraveyard.contains((Object)target.getFirstTarget()) && controller.moveCards(controllerGraveyard.get(target.getFirstTarget(), game), Zone.BATTLEFIELD, source, game);
    }
}

