/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.target.common.TargetControlledPermanent;

class NicolBolasDragonGodPlusOneEffect
extends OneShotEffect {
    NicolBolasDragonGodPlusOneEffect() {
        super(Outcome.Benefit);
        this.staticText = "You draw a card. Each opponent exiles a card from their hand or a permanent they control.";
    }

    private NicolBolasDragonGodPlusOneEffect(NicolBolasDragonGodPlusOneEffect effect) {
        super((OneShotEffect)effect);
    }

    public NicolBolasDragonGodPlusOneEffect copy() {
        return new NicolBolasDragonGodPlusOneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Boolean applied = false;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.drawCards(1, source, game);
        LinkedHashSet<Card> cardsOnBattlefield = new LinkedHashSet<Card>();
        LinkedHashSet<Card> cards = new LinkedHashSet<Card>();
        block0: for (UUID opponentId : game.getState().getPlayersInRange(player.getId(), game)) {
            Player opponent;
            if (!player.hasOpponent(opponentId, game) || (opponent = game.getPlayer(opponentId)) == null) continue;
            ArrayList<Object> possibleTargetTypes = new ArrayList<Object>();
            TargetCardInHand targetHand = new TargetCardInHand();
            if (!opponent.getHand().isEmpty()) {
                possibleTargetTypes.add(targetHand);
            }
            TargetControlledPermanent targetPermanent = new TargetControlledPermanent();
            targetPermanent.withNotTarget(true);
            targetPermanent.setTargetController(opponentId);
            if (!targetPermanent.possibleTargets(opponentId, source, game).isEmpty()) {
                possibleTargetTypes.add(targetPermanent);
            }
            if (possibleTargetTypes.size() > 1 && !opponent.chooseUse(Outcome.Benefit, "Exile a card in your hand or a permanent you control?", null, "Card in hand", "Permanent", source, game)) {
                Collections.reverse(possibleTargetTypes);
            }
            for (Target target : possibleTargetTypes) {
                MageObject mageObject;
                if (target.equals(targetHand) && opponent.choose(Outcome.Exile, opponent.getHand(), (TargetCard)targetHand, source, game) && game.getCard(targetHand.getFirstTarget()) != null) {
                    cards.add(game.getCard(targetHand.getFirstTarget()));
                    continue block0;
                }
                if (!target.equals(targetPermanent) || !opponent.choose(Outcome.Exile, (Target)targetPermanent, source, game) || !((mageObject = game.getObject(targetPermanent.getFirstTarget())) instanceof Permanent)) continue;
                cardsOnBattlefield.add((Card)mageObject);
                continue block0;
            }
        }
        cards.addAll(cardsOnBattlefield);
        for (Card card : cards) {
            Player owner;
            if (card == null || (owner = game.getPlayer(card.getOwnerId())) == null || !owner.moveCards(card, Zone.EXILED, source, game)) continue;
            applied = true;
        }
        return applied;
    }
}

