/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class NicolBolasGodPharaohPlusOneEffect
extends OneShotEffect {
    NicolBolasGodPharaohPlusOneEffect() {
        super(Outcome.Exile);
        this.staticText = "Each opponent exiles two cards from their hand.";
    }

    private NicolBolasGodPharaohPlusOneEffect(NicolBolasGodPharaohPlusOneEffect effect) {
        super((OneShotEffect)effect);
    }

    public NicolBolasGodPharaohPlusOneEffect copy() {
        return new NicolBolasGodPharaohPlusOneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Boolean applied = false;
        HashMap<UUID, CardsImpl> cardsToExile = new HashMap<UUID, CardsImpl>();
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            int numberOfCardsToExile = Math.min(2, opponent.getHand().size());
            if (numberOfCardsToExile > 0) {
                TargetCardInHand target = new TargetCardInHand(numberOfCardsToExile, new FilterCard());
                target.setRequired(true);
                if (!opponent.chooseTarget(Outcome.Exile, (Target)target, source, game)) continue;
                CardsImpl cards = new CardsImpl((Collection)target.getTargets());
                cardsToExile.put(opponentId, cards);
                continue;
            }
            cardsToExile.put(opponentId, new CardsImpl());
        }
        CardsImpl cardsOpponentsChoseToExile = new CardsImpl();
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || !cardsToExile.containsKey(opponentId)) continue;
            cardsOpponentsChoseToExile.addAll((Collection)cardsToExile.get(opponentId));
            opponent.moveCards((Cards)cardsOpponentsChoseToExile, Zone.EXILED, source, game);
            applied = true;
        }
        return applied;
    }
}

