/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class NicolBolasTheDeceiverFirstEffect
extends OneShotEffect {
    NicolBolasTheDeceiverFirstEffect() {
        super(Outcome.Damage);
        this.staticText = "Each opponent loses 3 life unless that player sacrifices a nonland permanent or discards a card";
    }

    private NicolBolasTheDeceiverFirstEffect(NicolBolasTheDeceiverFirstEffect effect) {
        super((OneShotEffect)effect);
    }

    public NicolBolasTheDeceiverFirstEffect copy() {
        return new NicolBolasTheDeceiverFirstEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID opponentId : game.getOpponents(controller.getId())) {
                Permanent permanent;
                TargetPermanent target;
                Player opponent = game.getPlayer(opponentId);
                if (opponent == null) continue;
                int permanents = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_NON_LAND, opponent.getId(), game);
                if (permanents > 0 && opponent.chooseUse(this.outcome, "Sacrifices a nonland permanent?", "Otherwise you have to discard a card or lose 3 life.", "Sacrifice", "Discard or life loss", source, game) && opponent.choose(this.outcome, (Target)(target = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_NON_LAND)), source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
                    permanent.sacrifice(source, game);
                    return true;
                }
                if (!opponent.getHand().isEmpty() && opponent.chooseUse(this.outcome, "Discard a card?", "Otherwise you lose 3 life.", "Discard", "Lose 3 life", source, game)) {
                    opponent.discardOne(false, false, source, game);
                    return true;
                }
                opponent.loseLife(3, game, source, false);
            }
            return true;
        }
        return false;
    }
}

