/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class NightmareIncursionEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.SWAMP);

    public NightmareIncursionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search target player's library for up to X cards, where X is the number of Swamps you control, and exile them. Then that player shuffles";
    }

    private NightmareIncursionEffect(NightmareIncursionEffect effect) {
        super((OneShotEffect)effect);
    }

    public NightmareIncursionEffect copy() {
        return new NightmareIncursionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (controller == null || targetPlayer == null) {
            return false;
        }
        int amount = game.getBattlefield().count(filter, source.getControllerId(), source, game);
        TargetCardInLibrary target = new TargetCardInLibrary(0, amount, StaticFilters.FILTER_CARD);
        if (controller.searchLibrary(target, source, game, targetPlayer.getId())) {
            CardsImpl cards = new CardsImpl((Collection)target.getTargets());
            controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        }
        targetPlayer.shuffleLibrary(source, game);
        return true;
    }
}

